-- -----------------------------------------------------------------------------
--  20191211
-- -----------------------------------------------------------------------------
--  Modify Sp_UpdateRespondentResponse to avoid asynchronous response overrides
-- -----------------------------------------------------------------------------

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
GO


CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
  @ProjectId     INT,
  @UserId        INT,
  @CollectMode   INT,
  @RpsRespondent VARCHAR(10),
  @RpsQuestion   VARCHAR(32),
  @RpsMatrix     BIGINT,
  @RpsMention    INT,
  @RpsContent    NVARCHAR(100),
  @RpsOpened     nvarchar(max),
  @RpsType       INT,
  @CallId        INT,
  @Source        nvarchar(max),
  @Modified      datetime = null,
  @QuestionOrder INT = null,
  @ChoiceOrder   INT = null
AS
  IF @Modified is null SET @Modified = GETUTCDATE();
  UPDATE Response
  SET ProjectId = @ProjectId,
      CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
      modifiedby = @UserId,
      modified = @Modified,
      RpsContent = @RpsContent,
      RpsOpened = @RpsOpened,
      CallId = @CallId,
      [Source] = @Source,
      QuestionOrder = @QuestionOrder,
      ChoiceOrder = @ChoiceOrder
  WHERE
    RpsRespondent = @RpsRespondent
    AND RpsQuestion = @RpsQuestion
    AND RpsMatrix = @RpsMatrix
    AND RpsMention = @RpsMention
    AND RpsType = @RpsType
    AND modified < @Modified
  IF @@ROWCOUNT = 0
  BEGIN TRY
  INSERT INTO Response
    (RpsRespondent,
     ProjectId,
     CollectMode,
     modifiedby,
     modified,
     RpsQuestion,
     RpsMatrix,
     RpsMention,
     RpsContent,
     RpsOpened,
     RpsType,
     CallId,
     [Source],
     QuestionOrder,
     ChoiceOrder)
  VALUES
    (@RpsRespondent,
    @ProjectId,
    @CollectMode,
    @UserId,
    @Modified,
    @RpsQuestion,
    @RpsMatrix,
    @RpsMention,
    @RpsContent,
    @rpsOpened,
    @rpsType,
    @CallId,
    @Source,
    @QuestionOrder,
    @ChoiceOrder)
  END TRY
  BEGIN CATCH
    IF ERROR_NUMBER() NOT IN (2601, 2627) -- Key violation
    BEGIN
      DECLARE @Num INT = ERROR_NUMBER()
      DECLARE @Msg NVARCHAR(200) = ERROR_MESSAGE()
      DECLARE @Severity INT = ERROR_SEVERITY()
      DECLARE @State INT = ERROR_STATE()
      RAISERROR('INNER ERROR: %d Message: %s', @Severity, @State, @Num, @Msg)
    END
  END CATCH
GO



